<?php
include_once("../include/main.inc.php");
check_session('MyCpanel', 'index.php');

// Extract and initialize safely
@extract($_REQUEST);

$catID = isset($catID) ? intval($catID) : 0;
$action = isset($action) ? $action : '';
$name = isset($name) ? trim($name) : '';
$caption = isset($caption) ? $caption : '';
$heading = empty($catID) ? "Add New Client Testimonial" : "Edit Client Testimonial";

$record_type = "Client Testimonial";
$script_name = "addedittestimonial.php";
$redirect_script_name = "manage-testimonial.php";
$table_name = "client_testi_tbl";

#################### Add Record ##################
if ($action == "add_record" && !empty($name)) {
    $numCnt = getCount($table_name, "WHERE name='" . addslashes($name) . "'");
    
    if ($numCnt > 0) {
        $_SESSION['session_message'] = '<div class="btn btn-warning">' . $record_type . ' already exists</div>';
    } else {
        $img = "";

        if (!empty($_FILES['clientimg']['name'])) {
            $file_extension = strtolower(getExtension($_FILES['clientimg']['name']));
            $allowed_extensions = ["jpg", "jpeg", "png", "gif", "webp"];

            if (in_array($file_extension, $allowed_extensions)) {
                $Client = rand(111, 999) . str_replace(" ", "-", $name);
                $img_name = $Client;
                $img = upload_file($img_name, "clientimg", "uploaded-files/client-image");
            } else {
                $_SESSION['session_message'] = '<div class="btn btn-warning">Please upload an image (.jpg, .jpeg, .png, .gif, .webp only)</div>';
                header("Location: " . SITE_ADMIN_URL . "/" . $script_name);
                exit;
            }
        }

        $caption_text = htmlentitiesDecode($caption_text);

        mysqli_query($GLOBALS['dbconn'], "INSERT INTO `$table_name` SET name='" . addslashes($name) . "',caption_text='" . addslashes($caption_text) . "',logo_image='" . addslashes($img) . "'");

        $_SESSION['session_message'] = '<div class="btn btn-success">' . $record_type . ' has been added successfully</div>';
        header("Location: " . SITE_ADMIN_URL . "/" . $redirect_script_name);
        exit;
    }
}

#################### Update Record ##################
if ($action == "update_record" && $catID > 0) {
    $numCnt = getCount($table_name, "WHERE name='" . addslashes($name) . "' AND id!='$catID'");

    if ($numCnt > 0) {
        $_SESSION['session_message'] = '<div class="btn btn-warning">' . $record_type . ' already exists</div>';
        header("Location: " . SITE_ADMIN_URL . "/" . $script_name . "?start=$start&parentID=$parentID&catID=$catID&pagesize=$pagesize");
        exit;
    }

    if (!empty($_FILES['clientimg']['name'])) {
        $file_extension = strtolower(getExtension($_FILES['clientimg']['name']));
        $allowed_extensions = ["jpg", "jpeg", "png", "gif", "webp"];

        if (!in_array($file_extension, $allowed_extensions)) {
            $_SESSION['session_message'] = '<div class="btn btn-warning">Please upload an image (.jpg, .jpeg, .png, .gif, .webp only)</div>';
            header("Location: " . SITE_ADMIN_URL . "/" . $script_name . "?start=$start&parentID=$parentID&catID=$catID&pagesize=$pagesize");
            exit;
        }

        $categoryRes = getRow($table_name, "WHERE id='$catID'", "logo_image");
        $filename = $categoryRes['logo_image'] ?? '';

        if (!empty($filename)) {
            $file_path = "../uploaded-files/client-image/" . $filename;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }

        $Client = rand(111, 999) . str_replace(" ", "-", $name);
        $img_name = $Client;
        $img = upload_file($img_name, "clientimg", "uploaded-files/client-image");

        updateTable($table_name, "logo_image='" . addslashes($img) . "' WHERE id='$catID'");
    }

     $caption_text = htmlentitiesDecode($caption_text);
    updateTable($table_name, "name='" . addslashes($name) . "', caption_text='" . addslashes($caption_text) . "' WHERE id='$catID'");

    $_SESSION['session_message'] = '<div class="btn btn-success">' . $record_type . ' has been updated successfully</div>';
    header("Location: " . SITE_ADMIN_URL . "/" . $redirect_script_name);
    exit;
}

########################################################
admin_header();
$sql = "SELECT * FROM $table_name WHERE id = $catID";
$res = mysqli_fetch_array(db_query($sql));

?>

<div class="content-wrapper">
<div class="page-header">
<h3 class="page-title">
<?=$heading;?>
</h3>
<nav aria-label="breadcrumb">
<ol class="breadcrumb">
<li class="nav-item d-none d-lg-flex">
<a class="nav-link" href="<?=$redirect_script_name?>">
<span class="btn btn-primary">Go Back</span>
</a>
</li>
</ol>
</nav>
</div>
<div class="row">

<div class="col-12 grid-margin stretch-card">
<div class="card">
<div class="card-body">
  <form class="forms-sample" method="POST" action=""  enctype="multipart/form-data">
<div class="form-group row">
    
<div class="col-lg-12">
<label>Client Name *</label>
<div id="the-basics">
<input class="typeahead" type="text" name="name" value="<?=$res['name']?>" placeholder="Client Name" required>
</div>
</div>



</div>
  
<div class="form-group">
 <label for="exampleTextarea1">Client Testimonial</label>
 <textarea class="form-control" rows="6" cols="50" name="caption_text"><?= $res['caption_text'] ?></textarea>
</div>

<?php if ($res['id'] == "") { ?>
<div class="form-group">
<label for="exampleTextarea1">Trusted Client Logo *</label>
<input type="file" class="dropify" name="clientimg">
</div>
<?php } else{ ?>
<div class="form-group row">
<div class="col">
<label>Trusted Client Logo</label>
<input type="file" class="dropify" name="clientimg">
</div>
<div class="col">
<img src="<?=site_url."/uploaded-files/client-image/".$res['logo_image']?>" alt="image" style="width: 60%;">
</div>
</div>
<?php } ?> 

<?php if ($res['id'] == "") {?>
<button type="submit" class="btn btn-primary mr-2" name="add_record">Submit</button>
<input type="hidden" name="action" value="add_record">
<?php } else {?>
<button type="submit" class="btn btn-primary mr-2" name="update_record">Update</button>
<input type="hidden" name="action" value="update_record">
<?php }?>
<button class="btn btn-light" onclick="javascript: window.location.href = '<?=SITE_ADMIN_URL;?>/<?= $redirect_script_name; ?>'">Cancel</button>
  </form>
</div>
</div>
</div>
</div>
</div>
<!-- content-wrapper ends -->
<?php
 admin_footer();
 exit;
?>